<?php

// File generated from our OpenAPI spec

namespace Stripe;

/**
 * A (partner) margin represents a specific discount distributed in partner reseller programs to business partners who
 * resell products and services and earn a discount (margin) for doing so.
 *
 * @property string $id Unique identifier for the object.
 * @property string $object String representing the object's type. Objects of the same type share the same value.
 * @property bool $active Whether the margin can be applied to invoices, invoice items, or invoice line items. Defaults to <code>true</code>.
 * @property int $created Time at which the object was created. Measured in seconds since the Unix epoch.
 * @property bool $livemode Has the value <code>true</code> if the object exists in live mode or the value <code>false</code> if the object exists in test mode.
 * @property null|StripeObject $metadata Set of <a href="https://stripe.com/docs/api/metadata">key-value pairs</a> that you can attach to an object. This can be useful for storing additional information about the object in a structured format.
 * @property null|string $name Name of the margin that's displayed on, for example, invoices.
 * @property float $percent_off Percent that will be taken off the subtotal before tax (after all other discounts and promotions) of any invoice to which the margin is applied.
 * @property int $updated Time at which the object was last updated. Measured in seconds since the Unix epoch.
 */
class Margin extends ApiResource
{
    const OBJECT_NAME = 'margin';

    use ApiOperations\Update;

    /**
     * Create a margin object to be used with invoices, invoice items, and invoice line
     * items for a customer to represent a partner discount. A margin has a
     * <code>percent_off</code> which is the percent that will be taken off the
     * subtotal after all items and other discounts and promotions) of any invoices for
     * a customer. Calculation of prorations do not include any partner margins applied
     * on the original invoice item.
     *
     * @param null|array{active?: bool, expand?: string[], metadata?: array<string, string>, name?: string, percent_off: float} $params
     * @param null|array|string $options
     *
     * @return Margin the created resource
     *
     * @throws Exception\ApiErrorException if the request fails
     */
    public static function create($params = null, $options = null)
    {
        self::_validateParams($params);
        $url = static::classUrl();

        list($response, $opts) = static::_staticRequest('post', $url, $params, $options);
        $obj = Util\Util::convertToStripeObject($response->json, $opts);
        $obj->setLastResponse($response);

        return $obj;
    }

    /**
     * Retrieve a list of your margins.
     *
     * @param null|array{active?: bool, ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|array|string $opts
     *
     * @return Collection<Margin> of ApiResources
     *
     * @throws Exception\ApiErrorException if the request fails
     */
    public static function all($params = null, $opts = null)
    {
        $url = static::classUrl();

        return static::_requestPage($url, Collection::class, $params, $opts);
    }

    /**
     * Retrieve a margin object with the given ID.
     *
     * @param array|string $id the ID of the API resource to retrieve, or an options array containing an `id` key
     * @param null|array|string $opts
     *
     * @return Margin
     *
     * @throws Exception\ApiErrorException if the request fails
     */
    public static function retrieve($id, $opts = null)
    {
        $opts = Util\RequestOptions::parse($opts);
        $instance = new static($id, $opts);
        $instance->refresh();

        return $instance;
    }

    /**
     * Update the specified margin object. Certain fields of the margin object are not
     * editable.
     *
     * @param string $id the ID of the resource to update
     * @param null|array{active?: bool, expand?: string[], metadata?: array<string, string>, name?: string} $params
     * @param null|array|string $opts
     *
     * @return Margin the updated resource
     *
     * @throws Exception\ApiErrorException if the request fails
     */
    public static function update($id, $params = null, $opts = null)
    {
        self::_validateParams($params);
        $url = static::resourceUrl($id);

        list($response, $opts) = static::_staticRequest('post', $url, $params, $opts);
        $obj = Util\Util::convertToStripeObject($response->json, $opts);
        $obj->setLastResponse($response);

        return $obj;
    }
}
