<?php

// File generated from our OpenAPI spec

namespace Stripe\Service;

/**
 * @phpstan-import-type RequestOptionsArray from \Stripe\Util\RequestOptions
 *
 * @psalm-import-type RequestOptionsArray from \Stripe\Util\RequestOptions
 */
class QuoteService extends AbstractService
{
    /**
     * Accepts the specified quote.
     *
     * @param string $id
     * @param null|array{expand?: string[]} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function accept($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s/accept', $id), $params, $opts);
    }

    /**
     * Returns a list of your quotes.
     *
     * @param null|array{customer?: string, customer_account?: string, ending_before?: string, expand?: string[], from_subscription?: string, limit?: int, starting_after?: string, status?: string, test_clock?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\Quote>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function all($params = null, $opts = null)
    {
        return $this->requestCollection('get', '/v1/quotes', $params, $opts);
    }

    /**
     * When retrieving a quote, there is an includable <a
     * href="https://stripe.com/docs/api/quotes/object#quote_object-computed-upfront-line_items"><strong>computed.upfront.line_items</strong></a>
     * property containing the first handful of those items. There is also a URL where
     * you can retrieve the full (paginated) list of upfront line items.
     *
     * @param string $id
     * @param null|array{ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\LineItem>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function allComputedUpfrontLineItems($id, $params = null, $opts = null)
    {
        return $this->requestCollection('get', $this->buildPath('/v1/quotes/%s/computed_upfront_line_items', $id), $params, $opts);
    }

    /**
     * When retrieving a quote, there is an includable <strong>line_items</strong>
     * property containing the first handful of those items. There is also a URL where
     * you can retrieve the full (paginated) list of line items.
     *
     * @param string $id
     * @param null|array{ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\LineItem>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function allLineItems($id, $params = null, $opts = null)
    {
        return $this->requestCollection('get', $this->buildPath('/v1/quotes/%s/line_items', $id), $params, $opts);
    }

    /**
     * Retrieves a paginated list of lines for a quote. These lines describe changes
     * that will be used to create new subscription schedules or update existing
     * subscription schedules when the quote is accepted.
     *
     * @param string $id
     * @param null|array{ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\QuoteLine>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function allLines($id, $params = null, $opts = null)
    {
        return $this->requestCollection('get', $this->buildPath('/v1/quotes/%s/lines', $id), $params, $opts);
    }

    /**
     * Preview the invoice line items that would be generated by accepting the quote.
     *
     * @param string $parentId
     * @param string $id
     * @param null|array{ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\InvoiceLineItem>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function allPreviewInvoiceLines($parentId, $id, $params = null, $opts = null)
    {
        return $this->requestCollection('get', $this->buildPath('/v1/quotes/%s/preview_invoices/%s/lines', $parentId, $id), $params, $opts);
    }

    /**
     * Preview the invoices that would be generated by accepting the quote.
     *
     * @param string $parentId
     * @param null|array{ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\QuotePreviewInvoice>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function allPreviewInvoices($parentId, $params = null, $opts = null)
    {
        return $this->requestCollection('get', $this->buildPath('/v1/quotes/%s/preview_invoices', $parentId), $params, $opts);
    }

    /**
     * Preview the schedules that would be generated by accepting the quote.
     *
     * @param string $parentId
     * @param null|array{ending_before?: string, expand?: string[], limit?: int, starting_after?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Collection<\Stripe\QuotePreviewSubscriptionSchedule>
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function allPreviewSubscriptionSchedules($parentId, $params = null, $opts = null)
    {
        return $this->requestCollection('get', $this->buildPath('/v1/quotes/%s/preview_subscription_schedules', $parentId), $params, $opts);
    }

    /**
     * Cancels the quote.
     *
     * @param string $id
     * @param null|array{expand?: string[]} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function cancel($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s/cancel', $id), $params, $opts);
    }

    /**
     * A quote models prices and services for a customer. Default options for
     * <code>header</code>, <code>description</code>, <code>footer</code>, and
     * <code>expires_at</code> can be set in the dashboard via the <a
     * href="https://dashboard.stripe.com/settings/billing/quote">quote template</a>.
     *
     * @param null|array{allow_backdated_lines?: bool, application_fee_amount?: null|int, application_fee_percent?: null|float, automatic_tax?: array{enabled: bool, liability?: array{account?: string, type: string}}, collection_method?: string, customer?: string, customer_account?: string, default_tax_rates?: null|string[], description?: null|string, discounts?: null|array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], expand?: string[], expires_at?: int, footer?: null|string, from_quote?: array{is_revision?: bool, quote: string}, header?: null|string, invoice_settings?: array{days_until_due?: int, issuer?: array{account?: string, type: string}}, line_items?: (array{discounts?: null|array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], price?: string, price_data?: array{currency: string, product: string, recurring?: array{interval: string, interval_count?: int}, tax_behavior?: string, unit_amount?: int, unit_amount_decimal?: string}, quantity?: int, tax_rates?: null|string[]})[], lines?: (array{actions?: (array{add_discount?: array{coupon?: string, discount?: string, discount_end?: array{type: string}, index?: int, promotion_code?: string}, add_item?: array{discounts?: array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], metadata?: array<string, string>, price: string, quantity?: int, tax_rates?: string[], trial?: array{converts_to?: string[], type: string}}, add_metadata?: array<string, string>, remove_discount?: array{coupon?: string, discount?: string, promotion_code?: string}, remove_item?: array{price: string}, remove_metadata?: string[], set_discounts?: array{coupon?: string, discount?: string, promotion_code?: string}[], set_items?: array{discounts?: array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], metadata?: array<string, string>, price: string, quantity?: int, tax_rates?: string[], trial?: array{converts_to?: string[], type: string}}[], set_metadata?: null|array<string, string>, type: string})[], applies_to?: array{new_reference?: string, subscription_schedule?: string, type: string}, billing_cycle_anchor?: string, cancel_subscription_schedule?: array{cancel_at: string, invoice_now?: bool, prorate?: bool}, ends_at?: array{discount_end?: array{discount: string}, duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, proration_behavior?: string, set_pause_collection?: array{set?: array{behavior: string}, type: string}, set_schedule_end?: string, starts_at?: array{discount_end?: array{discount: string}, line_ends_at?: array{index?: int}, timestamp?: int, type: string}, trial_settings?: array{end_behavior?: array{prorate_up_front?: string}}})[], metadata?: array<string, string>, on_behalf_of?: null|string, subscription_data?: array{bill_on_acceptance?: array{bill_from?: array{line_starts_at?: array{id?: string, index?: int}, timestamp?: int, type: string}, bill_until?: array{duration?: array{interval: string, interval_count: int}, line_ends_at?: array{id?: string, index?: int}, timestamp?: int, type: string}}, billing_behavior?: string, billing_cycle_anchor?: null|string, billing_mode?: array{flexible?: array{proration_discounts?: string}, type: string}, description?: string, effective_date?: null|array|int|string, end_behavior?: string, from_subscription?: string, metadata?: array<string, string>, prebilling?: null|array{iterations: int}, proration_behavior?: string, trial_period_days?: null|int}, subscription_data_overrides?: array{applies_to: array{new_reference?: string, subscription_schedule?: string, type: string}, bill_on_acceptance?: array{bill_from?: array{line_starts_at?: array{id?: string, index?: int}, timestamp?: int, type: string}, bill_until?: array{duration?: array{interval: string, interval_count: int}, line_ends_at?: array{id?: string, index?: int}, timestamp?: int, type: string}}, billing_behavior?: string, customer?: string, description?: string, end_behavior?: string, proration_behavior?: string}[], test_clock?: string, transfer_data?: null|array{amount?: int, amount_percent?: float, destination: string}} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function create($params = null, $opts = null)
    {
        return $this->request('post', '/v1/quotes', $params, $opts);
    }

    /**
     * Finalizes the quote.
     *
     * @param string $id
     * @param null|array{expand?: string[], expires_at?: int} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function finalizeQuote($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s/finalize', $id), $params, $opts);
    }

    /**
     * Converts a stale quote to draft.
     *
     * @param string $id
     * @param null|array{expand?: string[]} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function markDraft($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s/mark_draft', $id), $params, $opts);
    }

    /**
     * Converts a draft or open quote to stale.
     *
     * @param string $id
     * @param null|array{expand?: string[], reason?: string} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function markStale($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s/mark_stale', $id), $params, $opts);
    }

    /**
     * Download the PDF for a finalized quote. Explanation for special handling can be
     * found <a href="https://docs.stripe.com/quotes/overview#quote_pdf">here</a>.
     *
     * @param string $id
     * @param callable $readBodyChunkCallable
     * @param null|array{expand?: string[]} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return mixed
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function pdf($id, $readBodyChunkCallable, $params = null, $opts = null)
    {
        $opts = \Stripe\Util\RequestOptions::parse($opts);
        if (!isset($opts->apiBase)) {
            $opts->apiBase = $this->getClient()->getFilesBase();
        }

        return $this->requestStream('get', $this->buildPath('/v1/quotes/%s/pdf', $id), $readBodyChunkCallable, $params, $opts);
    }

    /**
     * Recompute the upcoming invoice estimate for the quote.
     *
     * @param string $id
     * @param null|array{expand?: string[]} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function reestimate($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s/reestimate', $id), $params, $opts);
    }

    /**
     * Retrieves the quote with the given ID.
     *
     * @param string $id
     * @param null|array{expand?: string[]} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function retrieve($id, $params = null, $opts = null)
    {
        return $this->request('get', $this->buildPath('/v1/quotes/%s', $id), $params, $opts);
    }

    /**
     * A quote models prices and services for a customer.
     *
     * @param string $id
     * @param null|array{allow_backdated_lines?: bool, application_fee_amount?: null|int, application_fee_percent?: null|float, automatic_tax?: array{enabled: bool, liability?: array{account?: string, type: string}}, collection_method?: string, customer?: string, customer_account?: string, default_tax_rates?: null|string[], description?: null|string, discounts?: null|array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], expand?: string[], expires_at?: int, footer?: null|string, header?: null|string, invoice_settings?: array{days_until_due?: int, issuer?: array{account?: string, type: string}}, line_items?: (array{discounts?: null|array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], id?: string, price?: string, price_data?: array{currency: string, product: string, recurring?: array{interval: string, interval_count?: int}, tax_behavior?: string, unit_amount?: int, unit_amount_decimal?: string}, quantity?: int, tax_rates?: null|string[]})[], lines?: (array{actions?: (array{add_discount?: array{coupon?: string, discount?: string, discount_end?: array{type: string}, index?: int, promotion_code?: string}, add_item?: array{discounts?: array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], metadata?: array<string, string>, price: string, quantity?: int, tax_rates?: string[], trial?: array{converts_to?: string[], type: string}}, add_metadata?: array<string, string>, remove_discount?: array{coupon?: string, discount?: string, promotion_code?: string}, remove_item?: array{price: string}, remove_metadata?: string[], set_discounts?: array{coupon?: string, discount?: string, promotion_code?: string}[], set_items?: array{discounts?: array{coupon?: string, discount?: string, discount_end?: array{duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, promotion_code?: string}[], metadata?: array<string, string>, price: string, quantity?: int, tax_rates?: string[], trial?: array{converts_to?: string[], type: string}}[], set_metadata?: null|array<string, string>, type: string})[], applies_to?: array{new_reference?: string, subscription_schedule?: string, type: string}, billing_cycle_anchor?: string, cancel_subscription_schedule?: array{cancel_at: string, invoice_now?: bool, prorate?: bool}, ends_at?: array{discount_end?: array{discount: string}, duration?: array{interval: string, interval_count: int}, timestamp?: int, type: string}, id?: string, proration_behavior?: string, set_pause_collection?: array{set?: array{behavior: string}, type: string}, set_schedule_end?: string, starts_at?: array{discount_end?: array{discount: string}, line_ends_at?: array{id?: string, index?: int}, timestamp?: int, type: string}, trial_settings?: array{end_behavior?: array{prorate_up_front?: string}}})[], metadata?: array<string, string>, on_behalf_of?: null|string, subscription_data?: array{bill_on_acceptance?: null|array{bill_from?: array{line_starts_at?: array{id?: string, index?: int}, timestamp?: int, type: string}, bill_until?: array{duration?: array{interval: string, interval_count: int}, line_ends_at?: array{id?: string, index?: int}, timestamp?: int, type: string}}, billing_behavior?: string, billing_cycle_anchor?: null|string, description?: null|string, effective_date?: null|array|int|string, end_behavior?: string, metadata?: array<string, string>, prebilling?: null|array{iterations: int}, proration_behavior?: string, trial_period_days?: null|int}, subscription_data_overrides?: null|(array{applies_to: array{new_reference?: string, subscription_schedule?: string, type: string}, bill_on_acceptance?: null|array{bill_from?: array{line_starts_at?: array{id?: string, index?: int}, timestamp?: int, type: string}, bill_until?: array{duration?: array{interval: string, interval_count: int}, line_ends_at?: array{id?: string, index?: int}, timestamp?: int, type: string}}, billing_behavior?: string, customer?: string, description?: null|string, end_behavior?: string, proration_behavior?: string})[], transfer_data?: null|array{amount?: int, amount_percent?: float, destination: string}} $params
     * @param null|RequestOptionsArray|\Stripe\Util\RequestOptions $opts
     *
     * @return \Stripe\Quote
     *
     * @throws \Stripe\Exception\ApiErrorException if the request fails
     */
    public function update($id, $params = null, $opts = null)
    {
        return $this->request('post', $this->buildPath('/v1/quotes/%s', $id), $params, $opts);
    }
}
