<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('Europe/Amsterdam');

// Laad geschiedenis
$logboek_file = 'logboek.txt';
$geschiedenis = file_exists($logboek_file) ? file($logboek_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];

// Variabelen
$filterdatum = $_GET['filterdatum'] ?? '';
$filtermaand = $_GET['filtermaand'] ?? '';
$startdatum = $_GET['startdatum'] ?? '';
$einddatum = $_GET['einddatum'] ?? '';
$totaal_vaatwas = 0;
$totaal_was = 0;
$dagelijks = [];

// Data verwerken
foreach ($geschiedenis as $regel) {
    list($tijd, $actie) = explode('|', $regel, 2);
    $datum = substr(trim($tijd), 0, 10); // Alleen YYYY-MM-DD

    // Filteren op dag
    if ($filterdatum && $datum !== $filterdatum) {
        continue;
    }

    // Filteren op maand
    if ($filtermaand && strpos($datum, $filtermaand) !== 0) {
        continue;
    }

    // Filteren op datumbereik
    if ($startdatum && $datum < $startdatum) {
        continue;
    }

    if ($einddatum && $datum > $einddatum) {
        continue;
    }

    // Tellen alleen 'verkocht' (niet afboekingen)
    if (strpos($actie, 'verkocht') !== false) {
        if (strpos($actie, 'vaatwasstrip') !== false) {
            if (preg_match('/(\d+) vaatwasstrip/', $actie, $matches)) {
                $totaal_vaatwas += (int)$matches[1];
                $dagelijks[$datum] = ($dagelijks[$datum] ?? 0) + (int)$matches[1];
            }
        }
        if (strpos($actie, 'wasstrip') !== false) {
            if (preg_match('/(\d+) wasstrip/', $actie, $matches)) {
                $totaal_was += (int)$matches[1];
                $dagelijks[$datum] = ($dagelijks[$datum] ?? 0) + (int)$matches[1];
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Statistieken - Bio-Suds</title>
    <div class="mb-4">
        <a href="https://bio-suds.nl/voorraad/" class="btn btn-outline-primary">📊 Terug naar Voorraadbeheer</a>
    </div>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
</head>
<body class="p-4">
<div class="container">
    <h1>Statistieken Bio-Suds</h1>

    <!-- Filter Formulier -->
    <form method="GET" class="row mb-4">
        <div class="col-md-4">
            <label>Kies een dag:</label>
            <input type="date" name="filterdatum" value="<?php echo htmlspecialchars($filterdatum); ?>" class="form-control">
        </div>
        <div class="col-md-4">
            <label>Kies een maand:</label>
            <input type="month" name="filtermaand" value="<?php echo htmlspecialchars($filtermaand); ?>" class="form-control">
        </div>
        <div class="col-md-4">
            <label>Kies een startdatum:</label>
            <input type="date" name="startdatum" value="<?php echo htmlspecialchars($startdatum); ?>" class="form-control">
        </div>
        <div class="col-md-4">
            <label>Kies een einddatum:</label>
            <input type="date" name="einddatum" value="<?php echo htmlspecialchars($einddatum); ?>" class="form-control">
        </div>
        <div class="col-md-4 align-self-end">
            <button type="submit" class="btn btn-primary">Filteren</button>
            <a href="statistieken.php" class="btn btn-secondary">Reset</a>
        </div>
    </form>

    <!-- Informatie over de totaal verkochte strips -->
    <div class="alert alert-info">
        📊 Totaal vaatwasstrips verkocht: <strong><?php echo $totaal_vaatwas; ?></strong><br>
        📊 Totaal wasstrips verkocht: <strong><?php echo $totaal_was; ?></strong>
    </div>

    <!-- Google Chart voor verkoop per dag -->
    <div id="grafiek" style="width: 100%; height: 500px;"></div>

</div>

<script type="text/javascript">
google.charts.load('current', {'packages':['corechart']});
google.charts.setOnLoadCallback(drawChart);

function drawChart() {
    var data = google.visualization.arrayToDataTable([
        ['Datum', 'Verkochte strips'],
        <?php
        if (!empty($dagelijks)) {
            foreach ($dagelijks as $datum => $aantal) {
                echo "['$datum', $aantal],";
            }
        } else {
            echo "['Geen data', 0],"; // Dummy regel zodat Google Charts niet crasht
        }
        ?>
    ]);

    var options = {
        title: 'Verkochte strips per dag',
        curveType: 'function',
        legend: { position: 'bottom' }
    };

    var chart = new google.visualization.LineChart(document.getElementById('grafiek'));
    chart.draw(data, options);
}
</script>
</body>
</html>
