<?php
session_start();
date_default_timezone_set('Europe/Amsterdam');

// Inklokken verwerken
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['project'])) {
    $_SESSION['project'] = $_POST['project'];
    $_SESSION['start_time'] = time();
} elseif (!isset($_SESSION['project']) || !isset($_SESSION['start_time'])) {
    header("Location: index.php");
    exit;
}

$project = $_SESSION['project'];
$startTimestamp = $_SESSION['start_time'];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Stop time</title>
    <link rel="stylesheet" href="assets/style.css">
    <script>
        let startTime = <?= $startTimestamp ?> * 1000;

        function updateTimer() {
            const now = Date.now();
            const diff = now - startTime;
            const totalSeconds = Math.floor(diff / 1000);
            const minutes = Math.floor(totalSeconds / 60);
            const seconds = totalSeconds % 60;
            document.getElementById('timer').textContent = `${minutes}m ${seconds}s`;
        }

        setInterval(updateTimer, 1000);
    </script>
</head>
<body onload="updateTimer()">

<?php include 'includes/menu.php'; ?>

<h2>⏱ Stop time <?= htmlspecialchars($project) ?></h2>
<p>🕒 Time active: <strong id="timer"></strong></p>

<form method="post" action="opslaan.php">
    <label for="description">Wat have you done?</label><br>
    <textarea name="description" id="description" rows="5" required></textarea><br><br>
    <button type="submit">Stop and save time</button>
</form>

</body>
</html>
