<?php
session_start();
date_default_timezone_set('Europe/Amsterdam');

// Controle: alles moet aanwezig zijn
if (!isset($_SESSION['project'], $_SESSION['start_time'], $_POST['description'])) {
    die("Ongeldige sessie of invoer.");
}

$project = $_SESSION['project'];
$start_time = $_SESSION['start_time'];
$end_time = time();
$description = trim($_POST['description']);
$duration = $end_time - $start_time;

// Log structureren
$log = [
    'start' => date('Y-m-d H:i:s', $start_time),
    'end' => date('Y-m-d H:i:s', $end_time),
    'duration_minutes' => round($duration / 60),
    'description' => $description
];

// Bestandsnaam genereren (slug)
$filename = 'logs/' . preg_replace('/[^a-zA-Z0-9_-]/', '_', $project) . '.json';

// Bestaande data ophalen of lege array
if (file_exists($filename)) {
    $data = json_decode(file_get_contents($filename), true);
    if (!is_array($data)) $data = [];
} else {
    $data = [];
}

// Nieuwe log toevoegen en opslaan
$data[] = $log;
file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));

// Sessie resetten
unset($_SESSION['project'], $_SESSION['start_time']);
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Log opgeslagen</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>

<?php include 'includes/menu.php'; ?>

<h2>✅ Log opgeslagen</h2>

<p>Je hebt succesvol uitgeklokt voor <strong><?= htmlspecialchars($project) ?></strong>.</p>
<p>Je activiteit is opgeslagen en toegevoegd aan het projectlogbestand.</p>

<p>
    <a href="index.php">⬅️ Terug naar inklokken</a><br>
    <a href="rapport.php?project=<?= urlencode($project) ?>">📄 Download rapport voor dit project (PDF)</a><br>
    <a href="overzicht.php">📋 Bekijk alle logs</a>
</p>

</body>
</html>
