<?php
$settingsFile = 'settings.json';
$password = 'admin'; // wachtwoord voor toegang

session_start();
if (!isset($_SESSION['logged_in']) && (!isset($_POST['password']) || $_POST['password'] !== $password)) {
    echo '<form method="POST"><input type="password" name="password" placeholder="Wachtwoord" /><button type="submit">Login</button></form>';
    exit;
} else {
    $_SESSION['logged_in'] = true;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
    $settings = [
        'pushover_user_key' => $_POST['pushover_user_key'],
        'pushover_app_token' => $_POST['pushover_app_token'],
        'client_1_id' => $_POST['client_1_id'],
        'client_1_secret' => $_POST['client_1_secret'],
        'client_2_id' => $_POST['client_2_id'],
        'client_2_secret' => $_POST['client_2_secret'],
        'html_notification' => isset($_POST['html_notification']) ? true : false
    ];
    file_put_contents($settingsFile, json_encode($settings, JSON_PRETTY_PRINT));
    $saved = true;
}

$settings = json_decode(file_get_contents($settingsFile), true);
?>

<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="UTF-8">
  <title>Instellingen</title>
  <style>
    body { font-family: Arial; max-width: 700px; margin: 40px auto; }
    label { display: block; margin-top: 20px; font-weight: bold; }
    input[type="text"], input[type="password"] { width: 100%; padding: 8px; }
    button { margin-top: 20px; padding: 10px 20px; }
  </style>
</head>
<body>
  <h1>Pushover Instellingen</h1>
  <?php if (!empty($saved)) echo "<p style='color: green;'>Instellingen opgeslagen!</p>"; ?>
  <form method="POST">
    <label>Pushover User Key</label>
    <input type="text" name="pushover_user_key" value="<?= htmlspecialchars($settings['pushover_user_key']) ?>">

    <label>Pushover App Token</label>
    <input type="text" name="pushover_app_token" value="<?= htmlspecialchars($settings['pushover_app_token']) ?>">

    <label>BOL Client 1 ID</label>
    <input type="text" name="client_1_id" value="<?= htmlspecialchars($settings['client_1_id']) ?>">

    <label>BOL Client 1 Secret</label>
    <input type="text" name="client_1_secret" value="<?= htmlspecialchars($settings['client_1_secret']) ?>">

    <label>BOL Client 2 ID</label>
    <input type="text" name="client_2_id" value="<?= htmlspecialchars($settings['client_2_id']) ?>">

    <label>BOL Client 2 Secret</label>
    <input type="text" name="client_2_secret" value="<?= htmlspecialchars($settings['client_2_secret']) ?>">

    <label>
      <input type="checkbox" name="html_notification" <?= $settings['html_notification'] ? 'checked' : '' ?>>
      HTML Bericht gebruiken
    </label>

    <button type="submit" name="save">Opslaan</button>
  </form>
</body>
</html>
