<?php
$settingsFile = 'settings.json';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings = [
        'pushover_api_key' => $_POST['pushover_api_key'],
        'pushover_user_key' => $_POST['pushover_user_key'],
        'default_sound' => $_POST['default_sound'],
        'bol_message' => $_POST['bol_message'],
        'shopify_message' => $_POST['shopify_message'],
    ];
    file_put_contents($settingsFile, json_encode($settings, JSON_PRETTY_PRINT));
    $saved = true;
}

$settings = json_decode(file_get_contents($settingsFile), true);
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Instellingen</title>
    <style>
        body { font-family: sans-serif; max-width: 600px; margin: 40px auto; }
        label { display: block; margin-top: 20px; }
        input, textarea { width: 100%; padding: 8px; margin-top: 4px; }
        button { margin-top: 20px; padding: 10px 20px; }
        .success { color: green; }
    </style>
</head>
<body>
    <h1>Instellingen voor Pushover systeem</h1>

    <?php if (!empty($saved)) echo "<p class='success'>Instellingen opgeslagen!</p>"; ?>

    <form method="POST">
        <label>API Key
            <input type="text" name="pushover_api_key" value="<?= htmlspecialchars($settings['pushover_api_key']) ?>">
        </label>

        <label>User Key
            <input type="text" name="pushover_user_key" value="<?= htmlspecialchars($settings['pushover_user_key']) ?>">
        </label>

        <label>Standaardgeluid
            <input type="text" name="default_sound" value="<?= htmlspecialchars($settings['default_sound']) ?>">
        </label>

        <label>Bericht voor Bol order
            <textarea name="bol_message"><?= htmlspecialchars($settings['bol_message']) ?></textarea>
        </label>

        <label>Bericht voor Shopify order
            <textarea name="shopify_message"><?= htmlspecialchars($settings['shopify_message']) ?></textarea>
        </label>

        <button type="submit">Opslaan</button>
    </form>
</body>
</html>
