<?php
$settings_file = __DIR__ . '/settings.php';

$settings = file_exists($settings_file) ? include $settings_file : [
    'accounts' => [],
    'pushover' => [],
    'melding' => []
];

$geluid_opties = ['pushover', 'bike', 'bugle', 'cashregister', 'classical', 'cosmic', 'falling', 'gamelan', 'incoming', 'intermission', 'magic', 'mechanical', 'pianobar', 'siren', 'spacealarm', 'tugboat', 'alien', 'climb'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings['accounts'] = [
        'NL' => [
            'client_id' => $_POST['nl_client_id'],
            'client_secret' => $_POST['nl_client_secret'],
        ],
        'BE' => [
            'client_id' => $_POST['be_client_id'],
            'client_secret' => $_POST['be_client_secret'],
        ]
    ];
    $settings['pushover'] = [
        'user_key' => $_POST['pushover_user_key'],
        'app_token' => $_POST['pushover_app_token']
    ];

    $melding_titel = $_POST['melding_titel'] ?? 'Nieuwe Bol.com bestelling';
    $geluid_drempels = [];
    foreach ($_POST['geluid_bedrag'] as $index => $bedrag) {
        $geluid_drempels[] = [
            'bedrag' => floatval($bedrag),
            'sound' => $_POST['geluid_sound'][$index] ?? 'pushover'
        ];
    }

    $settings['melding'] = [
        'titel' => $melding_titel,
        'geluid_drempels' => $geluid_drempels
    ];

    file_put_contents($settings_file, "<?php\n\nreturn " . var_export($settings, true) . ";\n");
    $message = "✅ Instellingen opgeslagen.";
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Pushyfy Instellingen</title>
    <style>
        body { font-family: sans-serif; background: #f0f0f0; padding: 2rem; }
        .container { background: white; padding: 2rem; max-width: 800px; margin: auto; border-radius: 8px; box-shadow: 0 0 12px rgba(0,0,0,0.1); }
        input, select { width: 100%; padding: 8px; margin-bottom: 12px; }
        input[type=submit] { background: #2a7ae2; color: white; border: none; cursor: pointer; }
        h2 { margin-top: 2rem; }
        .success { background: #d4edda; padding: 1rem; border: 1px solid #c3e6cb; margin-bottom: 1rem; border-radius: 4px; }
    </style>
    <script>
function testGeluid(sound) {
    fetch('test_sound.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ sound })
    })
    .then(res => res.text())
    .then(msg => alert(msg))
    .catch(err => alert("Fout bij versturen testgeluid"));
}
</script>

</head>
<body>
<div class="container">
    <h1>Pushyfy Instellingen</h1>

    <?php if (!empty($message)) : ?>
        <div class="success"><?= $message ?></div>
    <?php endif; ?>

    <form method="post">
        <h2>Bol.com Account NL</h2>
        <label>Client ID</label>
        <input type="text" name="nl_client_id" value="<?= htmlspecialchars($settings['accounts']['NL']['client_id'] ?? '') ?>" required>
        <label>Client Secret</label>
        <input type="password" name="nl_client_secret" value="<?= htmlspecialchars($settings['accounts']['NL']['client_secret'] ?? '') ?>" required>

        <h2>Bol.com Account BE</h2>
        <label>Client ID</label>
        <input type="text" name="be_client_id" value="<?= htmlspecialchars($settings['accounts']['BE']['client_id'] ?? '') ?>" required>
        <label>Client Secret</label>
        <input type="password" name="be_client_secret" value="<?= htmlspecialchars($settings['accounts']['BE']['client_secret'] ?? '') ?>" required>

        <h2>Pushover</h2>
        <label>User Key</label>
        <input type="text" name="pushover_user_key" value="<?= htmlspecialchars($settings['pushover']['user_key'] ?? '') ?>" required>
        <label>App Token</label>
        <input type="text" name="pushover_app_token" value="<?= htmlspecialchars($settings['pushover']['app_token'] ?? '') ?>" required>

        <h2>Pushmelding Instellingen</h2>
        <label>Titel van melding</label>
        <input type="text" name="melding_titel" value="<?= htmlspecialchars($settings['melding']['titel'] ?? '') ?>" required>

        <h3>Geluiden op basis van orderwaarde</h3>
        <?php
        $drempels = $settings['melding']['geluid_drempels'] ?? [];
        if (empty($drempels)) {
            $drempels = [
                ['bedrag' => 7, 'sound' => 'cashregister'],
                ['bedrag' => 20, 'sound' => 'bike'],
                ['bedrag' => 50, 'sound' => 'magic'],
                ['bedrag' => 999999, 'sound' => 'siren'],
            ];
        }
        foreach ($drempels as $i => $drempel): ?>
            <label>Tot bedrag (€)</label>
            <input type="number" name="geluid_bedrag[]" value="<?= $drempel['bedrag'] ?>" step="0.01" required>
            <label>Geluid</label>
           <div style="display: flex; gap: 10px; align-items: center;">
    <select name="geluid_sound[]">
        <?php foreach ($geluid_opties as $optie): ?>
            <option value="<?= $optie ?>" <?= $optie === $drempel['sound'] ? 'selected' : '' ?>>
                <?= ucfirst($optie) ?>
            </option>
        <?php endforeach; ?>
    </select>
    <button type="button" onclick="testGeluid(this.previousElementSibling.value)">🔊 Test</button>
</div>

        <?php endforeach; ?>

        <input type="submit" value="Instellingen opslaan">
    </form>
</div>
</body>
</html>
