<?php
$tasksFile = '../data/tasks.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';
$dealsFile = '../data/deals.json';
date_default_timezone_set('Europe/Amsterdam');


$tasks = file_exists($tasksFile) ? json_decode(file_get_contents($tasksFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = uniqid();
    $tasks[$id] = [
        'titel' => $_POST['titel'],
        'status' => $_POST['status'],
        'vervaldatum' => $_POST['vervaldatum'],
        'aantekeningen' => $_POST['aantekeningen'],
        'contact_id' => $_POST['contact_id'] ?? '',
        'company_id' => $_POST['company_id'] ?? '',
        'deal_id' => $_POST['deal_id'] ?? ''
    ];
    file_put_contents($tasksFile, json_encode($tasks, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Nieuwe Taak</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Nieuwe Taak</h2>
    <form method="post">
        <div class="mb-3">
            <input type="text" name="titel" class="form-control" placeholder="Titel van de taak" required>
        </div>

        <div class="mb-3">
            <select name="status" class="form-control" required>
                <option value="Open">Open</option>
                <option value="Afgerond">Afgerond</option>
                <option value="Bellen">Bellen</option>
                <option value="Mailen">Mailen</option>
            </select>
        </div>

        <div class="mb-3">
            <input type="date" name="vervaldatum" class="form-control" required>
        </div>

        <div class="mb-3">
            <textarea name="aantekeningen" class="form-control" placeholder="Aantekeningen"></textarea>
        </div>

        <div class="mb-3">
            <label>Contactpersoon koppelen (optioneel):</label>
            <select name="contact_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($contacts as $id => $c): ?>
                    <option value="<?= $id ?>"><?= htmlspecialchars($c['naam']) ?></option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Bedrijf koppelen (optioneel):</label>
            <select name="company_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($companies as $id => $co): ?>
                    <option value="<?= $id ?>"><?= htmlspecialchars($co['naam']) ?></option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Deal koppelen (optioneel):</label>
            <select name="deal_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($deals as $id => $d): ?>
                    <option value="<?= $id ?>"><?= htmlspecialchars($d['naam']) ?></option>
                <?php endforeach ?>
            </select>
        </div>

        <button type="submit" class="btn btn-success">Opslaan</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
