<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$tasksFile = '../data/tasks.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';
$dealsFile = '../data/deals.json';

$tasks = file_exists($tasksFile) ? json_decode(file_get_contents($tasksFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];

// FILTER op status
// FILTER op status
$statusFilter = $_GET['status'] ?? 'Open';
if ($statusFilter) {
    $tasks = array_filter($tasks, function ($t) use ($statusFilter) {
        if ($statusFilter === 'Open') {
            // Toon ook Bellen en Mailen bij Open
            return in_array($t['status'], ['Open', 'Bellen', 'Mailen']);
        }
        return $t['status'] === $statusFilter;
    });
}


// SORTEREN op vervaldatum
uasort($tasks, function ($a, $b) {
    return strtotime($a['vervaldatum']) <=> strtotime($b['vervaldatum']);
});

// Slimme datumweergave
function formatVervaldatumSlim($datum) {
    $vandaag = new DateTime();
$doeldatum = DateTime::createFromFormat('Y-m-d', $datum);
if ($doeldatum) {
    $doeldatum->modify('+1 day'); // altijd 1 dag vooruitzetten
}
    if (!$doeldatum) return htmlspecialchars($datum);

    $verschil = (int)$doeldatum->diff($vandaag)->format('%r%a');

    if ($verschil === 0) return 'Vandaag';
    if ($verschil === -1) return 'Morgen';
    if ($verschil > -7 && $verschil < 0) return 'Over ' . abs($verschil) . ' dagen';
    if ($verschil === 1) return 'Gisteren';
    if ($verschil > 0 && $verschil < 7) return $verschil . ' dagen geleden';

    return $doeldatum->format('d-m-Y');
}

// Kleurklasse voor deadline
function taakKleurKlasse($datum, $status) {
    $vandaag = new DateTime();
    $verval = DateTime::createFromFormat('Y-m-d', date('Y-m-d', strtotime($datum)));
    if (!$verval) return '';

    $verschil = (int)$verval->diff($vandaag)->format('%r%a');

    if ($status !== 'Afgerond' && $verschil > 0) return 'table-danger';        // Te laat
    if ($verschil === 0) return 'table-warning';                               // Vandaag
    if ($verschil === -1) return 'table-info';                                 // Morgen
    if ($verschil >= -3 && $verschil < 0) return 'table-light';                // Binnenkort
    return '';
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Taken</title>
    <link rel="icon" type="image/png" href="/crm/favicon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Taken <?= $statusFilter ? '– ' . htmlspecialchars($statusFilter) : '' ?></h2>
    <a href="nieuw.php" class="btn btn-primary mb-3">Nieuwe taak</a>

    <!-- FILTER -->
    <form method="get" class="mb-4">
        <div class="row g-2 align-items-end">
            <div class="col-auto">
                <label for="status" class="form-label">Filter op status:</label>
<select name="status" id="status" class="form-select">
    <option value="">— Alles —</option>
    <option value="Open" <?= $statusFilter === 'Open' ? 'selected' : '' ?>>Open</option>
    <option value="Afgerond" <?= $statusFilter === 'Afgerond' ? 'selected' : '' ?>>Afgerond</option>
    <option value="Bellen" <?= $statusFilter === 'Bellen' ? 'selected' : '' ?>>Bellen</option>
    <option value="Mailen" <?= $statusFilter === 'Mailen' ? 'selected' : '' ?>>Mailen</option>
</select>
            </div>
            <div class="col-auto">
                <button type="submit" class="btn btn-primary">Toepassen</button>
                <a href="index.php" class="btn btn-secondary">Reset</a>
            </div>
        </div>
    </form>

    <?php if (count($tasks) === 0): ?>
        <p>Er zijn geen taken gevonden.</p>
    <?php else: ?>
        <table class="table table-bordered table-hover align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Titel</th>
                    <th>Status</th>
                    <th>Vervaldatum</th>
                    <th>Koppeling</th>
                    <th>Aantekeningen</th>
                    <th>Acties</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($tasks as $id => $t): ?>
                    <tr class="<?= taakKleurKlasse($t['vervaldatum'], $t['status']) ?>">
                        <td><?= htmlspecialchars($t['titel']) ?></td>
                        <td><?= htmlspecialchars($t['status']) ?></td>
                        <td><?= formatVervaldatumSlim($t['vervaldatum']) ?></td>
                        <td>
                            <?php
                            if (!empty($t['contact_id']) && isset($contacts[$t['contact_id']])) {
                                $cid = $t['contact_id'];
                                $cnaam = htmlspecialchars($contacts[$cid]['naam']);
                                echo "Contact: <a href=\"../contacts/bewerken.php?id=$cid\">$cnaam</a>";
                            } elseif (!empty($t['company_id']) && isset($companies[$t['company_id']])) {
                                echo "Bedrijf: " . htmlspecialchars($companies[$t['company_id']]['naam']);
                            } elseif (!empty($t['deal_id']) && isset($deals[$t['deal_id']])) {
                                echo "Deal: " . htmlspecialchars($deals[$t['deal_id']]['naam']);
                            } else {
                                echo '—';
                            }
                            ?>
                        </td>
                        <td><?= nl2br(htmlspecialchars($t['aantekeningen'])) ?></td>
                        <td class="d-flex gap-1 flex-wrap">
                            <?php if ($t['status'] !== 'Afgerond'): ?>
                                <a href="afronden.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-success">✔ Afgeronden</a>
                            <?php endif; ?>
                            <a href="bewerken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-warning">Bewerken</a>
                            <a href="verwijderen.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-danger">Verwijderen</a>
                        </td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    <?php endif ?>
</div>
</body>
</html>
