<?php
$tasksFile = '../data/tasks.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';
$dealsFile = '../data/deals.json';

$tasks = file_exists($tasksFile) ? json_decode(file_get_contents($tasksFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($tasks[$id])) {
    die('Taak niet gevonden.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $tasks[$id] = [
        'titel' => $_POST['titel'],
        'status' => $_POST['status'],
        'vervaldatum' => $_POST['vervaldatum'],
        'aantekeningen' => $_POST['aantekeningen'],
        'contact_id' => $_POST['contact_id'] ?? '',
        'company_id' => $_POST['company_id'] ?? '',
        'deal_id' => $_POST['deal_id'] ?? ''
    ];
    file_put_contents($tasksFile, json_encode($tasks, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}

$t = $tasks[$id];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Taak bewerken</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Taak bewerken</h2>
    <form method="post">
        <div class="mb-3"><input type="text" name="titel" class="form-control" value="<?= htmlspecialchars($t['titel']) ?>" required></div>

        <div class="mb-3">
<select name="status" class="form-control">
    <option value="Open" <?= $t['status'] === 'Open' ? 'selected' : '' ?>>Open</option>
    <option value="Afgerond" <?= $t['status'] === 'Afgerond' ? 'selected' : '' ?>>Afgerond</option>
    <option value="Bellen" <?= $t['status'] === 'Bellen' ? 'selected' : '' ?>>Bellen</option>
    <option value="Mailen" <?= $t['status'] === 'Mailen' ? 'selected' : '' ?>>Mailen</option>
</select>

        </div>

        <div class="mb-3"><input type="date" name="vervaldatum" class="form-control" value="<?= htmlspecialchars($t['vervaldatum']) ?>" required></div>

        <div class="mb-3"><textarea name="aantekeningen" class="form-control"><?= htmlspecialchars($t['aantekeningen']) ?></textarea></div>

        <div class="mb-3">
            <label>Contactpersoon:</label>
            <select name="contact_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($contacts as $cid => $c): ?>
                    <option value="<?= $cid ?>" <?= $cid === $t['contact_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($c['naam']) ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Bedrijf:</label>
            <select name="company_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($companies as $coid => $co): ?>
                    <option value="<?= $coid ?>" <?= $coid === $t['company_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($co['naam']) ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label>Deal:</label>
            <select name="deal_id" class="form-control">
                <option value="">— Geen —</option>
                <?php foreach ($deals as $did => $d): ?>
                    <option value="<?= $did ?>" <?= $did === $t['deal_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($d['naam']) ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>

        <button type="submit" class="btn btn-success">Opslaan</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
