<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

$companiesFile = '../data/companies.json';
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

$regels = [];
$totaalBetaald = 0;
$totaalAlles = 0;

foreach ($companies as $bedrijfId => $bedrijf) {
    $naam = $bedrijf['naam'] ?? '—';
    $regelsPerBedrijf = $bedrijf['omzetregels'] ?? [];

    foreach ($regelsPerBedrijf as $regel) {
        $datum = $regel['datum'] ?? '';
        $omschrijving = $regel['omschrijving'] ?? '';
        $bedrag = floatval($regel['bedrag'] ?? 0);
        $status = $regel['status'] ?? ($regel['betaald'] ?? 'Wachten op betaling');

        $regels[] = [
            'bedrijf' => $naam,
            'datum' => $datum,
            'omschrijving' => $omschrijving,
            'bedrag' => $bedrag,
            'status' => $status
        ];

        $totaalAlles += $bedrag;
        if (strtolower($status) === 'betaald') {
            $totaalBetaald += $bedrag;
        }
    }
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Omzetoverzicht</title>
    <link rel="icon" type="image/png" href="/crm/favicon.png">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">📊 Omzetoverzicht</h2>

    <div class="row mb-4">
        <div class="col-md-6">
            <div class="alert alert-success">
                ✅ Totaal <strong>betaald</strong>: <strong>€ <?= number_format($totaalBetaald, 2, ',', '.') ?></strong>
            </div>
        </div>
        <div class="col-md-6">
            <div class="alert alert-warning">
                💰 Totaal <strong>alle regels</strong>: <strong>€ <?= number_format($totaalAlles, 2, ',', '.') ?></strong>
            </div>
        </div>
    </div>

    <table class="table table-bordered table-hover align-middle">
        <thead class="table-dark">
            <tr>
                <th>Bedrijf</th>
                <th>Datum</th>
                <th>Omschrijving</th>
                <th>Bedrag</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($regels as $r): ?>
                <tr>
                    <td><?= htmlspecialchars($r['bedrijf']) ?></td>
                    <td><?= $r['datum'] ? date('d-m-Y', strtotime($r['datum'])) : '—' ?></td>
                    <td><?= htmlspecialchars($r['omschrijving']) ?></td>
                    <td>€ <?= number_format($r['bedrag'], 2, ',', '.') ?></td>
                    <td>
                        <?php
                        $s = strtolower($r['status']);
                        if ($s === 'betaald') {
                            echo '✅ Betaald';
                        } elseif ($s === 'niet betaald') {
                            echo '❌ Niet betaald';
                        } else {
                            echo '⏳ Wachten op betaling';
                        }
                        ?>
                    </td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>
</div>
</body>
</html>
