<?php
$dealsFile = '../data/deals.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';

$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($deals[$id])) {
    die('Deal niet gevonden.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $deals[$id] = [
        'naam' => $_POST['naam'] ?? '',
        'stadium' => $_POST['stadium'] ?? '',
        'type' => $_POST['type'] ?? '',
        'jaartal' => $_POST['jaartal'] ?? '',
        'sluitingsdatum' => $_POST['sluitingsdatum'] ?? '',
        'bedrag' => $_POST['bedrag'] ?? '0',
        'barter' => $_POST['barter'] ?? 'nee',
        'barter_type' => $_POST['barter_type'] ?? '',
        'barter_omschrijving' => $_POST['barter_omschrijving'] ?? '',
        'barter_bedrag' => $_POST['barter_bedrag'] ?? '0',
        'contact_id' => $_POST['contact_id'] ?? '',
        'company_id' => $_POST['company_id'] ?? '',
        'opmerkingen' => $_POST['opmerkingen'] ?? ''
    ];
    file_put_contents($dealsFile, json_encode($deals, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}

$d = $deals[$id];

// Velden controleren op bestaan
$velden = ['naam', 'stadium', 'type', 'jaartal', 'sluitingsdatum', 'bedrag', 'barter', 'barter_type', 'barter_omschrijving', 'barter_bedrag', 'contact_id', 'company_id', 'opmerkingen'];
foreach ($velden as $veld) {
    if (!isset($d[$veld])) $d[$veld] = '';
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Deal bewerken</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script>
        function toggleBarterDetails() {
            const isBarter = document.querySelector('select[name="barter"]').value === 'ja';
            document.getElementById('barter-details').style.display = isBarter ? 'block' : 'none';
        }
    </script>
</head>
<body class="bg-light" onload="toggleBarterDetails()">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Deal bewerken</h2>
    <form method="post">

        <div class="mb-3">
            <label for="naam" class="form-label">Naam</label>
            <input type="text" name="naam" class="form-control" value="<?= htmlspecialchars($d['naam']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="stadium" class="form-label">Stadium</label>
            <select name="stadium" class="form-select" required>
                <?php
                $stadia = [
                    "Suspect", 
                    "Lead", 
                    "Prospect", 
                    "Hot Prospect",
                    "Relatie - Toesturen factuur",
                    "Relatie - Gesloten, gewonnen",
                    "Relatie - Gesloten, verloren",
                    "Relatie - Postponed"
                ];
                foreach ($stadia as $s) {
                    $sel = $d['stadium'] === $s ? 'selected' : '';
                    echo "<option value=\"$s\" $sel>$s</option>";
                }
                ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="type" class="form-label">Type deal</label>
            <select name="type" class="form-select">
                <?php
                $types = ["Ambassadeur", "B&B", "Kapperszaak", "Kledingzaak", "Restaurant", "Hotel", "Voetbal", "Overig"];
                foreach ($types as $t) {
                    $sel = $d['type'] === $t ? 'selected' : '';
                    echo "<option value=\"$t\" $sel>$t</option>";
                }
                ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="jaartal" class="form-label">Jaartal</label>
            <input type="number" name="jaartal" class="form-control" value="<?= htmlspecialchars($d['jaartal']) ?>">
        </div>

        <div class="mb-3">
            <label for="sluitingsdatum" class="form-label">Sluitingsdatum</label>
            <input type="date" name="sluitingsdatum" class="form-control" value="<?= htmlspecialchars($d['sluitingsdatum']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="bedrag" class="form-label">Bedrag</label>
            <input type="number" step="0.01" name="bedrag" class="form-control" value="<?= htmlspecialchars($d['bedrag']) ?>">
        </div>

        <div class="mb-3">
            <label for="barter" class="form-label">Barter?</label>
            <select name="barter" class="form-select" onchange="toggleBarterDetails()">
                <option value="nee" <?= $d['barter'] === 'nee' ? 'selected' : '' ?>>Nee</option>
                <option value="ja" <?= $d['barter'] === 'ja' ? 'selected' : '' ?>>Ja</option>
            </select>
        </div>

        <div id="barter-details" style="display: none;">
            <div class="mb-3">
                <label for="barter_type" class="form-label">Type barter</label>
                <input type="text" name="barter_type" class="form-control" value="<?= htmlspecialchars($d['barter_type']) ?>">
            </div>
            <div class="mb-3">
                <label for="barter_omschrijving" class="form-label">Barteromschrijving</label>
                <textarea name="barter_omschrijving" class="form-control"><?= htmlspecialchars($d['barter_omschrijving']) ?></textarea>
            </div>
            <div class="mb-3">
                <label for="barter_bedrag" class="form-label">Barterbedrag</label>
                <input type="number" step="0.01" name="barter_bedrag" class="form-control" value="<?= htmlspecialchars($d['barter_bedrag']) ?>">
            </div>
        </div>

        <div class="mb-3">
            <label for="contact_id" class="form-label">Contactpersoon</label>
            <select name="contact_id" class="form-select">
                <option value="">— Geen —</option>
                <?php foreach ($contacts as $cid => $c): ?>
                    <option value="<?= $cid ?>" <?= $cid === $d['contact_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($c['naam']) ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="company_id" class="form-label">Bedrijf</label>
            <select name="company_id" class="form-select">
                <option value="">— Geen —</option>
                <?php foreach ($companies as $coid => $co): ?>
                    <option value="<?= $coid ?>" <?= $coid === $d['company_id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($co['naam']) ?>
                    </option>
                <?php endforeach ?>
            </select>
        </div>

        <div class="mb-3">
            <label for="opmerkingen" class="form-label">Opmerkingen / Notities</label>
            <textarea name="opmerkingen" class="form-control" rows="4"><?= htmlspecialchars($d['opmerkingen']) ?></textarea>
        </div>

        <button type="submit" class="btn btn-success">Opslaan</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
