<?php
$dealsFile = '../data/deals.json';
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';

$deals = file_exists($dealsFile) ? json_decode(file_get_contents($dealsFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($deals[$id])) {
    die('Deal niet gevonden.');
}

$d = $deals[$id];
$contact = !empty($d['contact_id']) && isset($contacts[$d['contact_id']]) ? $contacts[$d['contact_id']] : null;
$bedrijf = !empty($d['company_id']) && isset($companies[$d['company_id']]) ? $companies[$d['company_id']] : null;
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Deal bekijken</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Deal: <?= htmlspecialchars($d['naam']) ?></h2>

    <ul class="list-group mb-4">
        <li class="list-group-item"><strong>Stadium:</strong> <?= htmlspecialchars($d['stadium']) ?></li>
        <li class="list-group-item"><strong>Type:</strong> <?= htmlspecialchars($d['type']) ?></li>
        <li class="list-group-item"><strong>Jaartal:</strong> <?= htmlspecialchars($d['jaartal']) ?></li>
        <li class="list-group-item"><strong>Sluitingsdatum:</strong> <?= date('d-m-Y', strtotime($d['sluitingsdatum'])) ?></li>
        <li class="list-group-item"><strong>Bedrag:</strong> €<?= htmlspecialchars($d['bedrag']) ?></li>
        <li class="list-group-item"><strong>Barter:</strong> <?= $d['barter'] === 'ja' ? '✅ Ja' : '❌ Nee' ?></li>
        <?php if ($d['barter'] === 'ja'): ?>
            <li class="list-group-item"><strong>Type:</strong> <?= htmlspecialchars($d['barter_type']) ?></li>
            <li class="list-group-item"><strong>Omschrijving:</strong> <?= nl2br(htmlspecialchars($d['barter_omschrijving'])) ?></li>
            <li class="list-group-item"><strong>Bedrag:</strong> €<?= htmlspecialchars($d['barter_bedrag']) ?></li>
        <?php endif; ?>
    </ul>

    <?php if ($contact): ?>
        <h4>Contactpersoon</h4>
        <ul class="list-group mb-4">
            <li class="list-group-item"><strong>Naam:</strong> <?= htmlspecialchars($contact['naam']) ?></li>
            <li class="list-group-item"><strong>E-mail:</strong> <a href="mailto:<?= htmlspecialchars($contact['email']) ?>"><?= htmlspecialchars($contact['email']) ?></a></li>
            <li class="list-group-item"><strong>Mobiel:</strong> <?= htmlspecialchars($contact['mobiel']) ?></li>
            <li class="list-group-item"><strong>Functie:</strong> <?= htmlspecialchars($contact['functie']) ?></li>
            <li class="list-group-item"><a href="../contacts/bewerken.php?id=<?= urlencode($d['contact_id']) ?>" class="btn btn-sm btn-outline-primary mt-2">Bekijk contact</a></li>
        </ul>
    <?php endif; ?>

    <?php if ($bedrijf): ?>
        <h4>Bedrijf</h4>
        <ul class="list-group mb-4">
            <li class="list-group-item"><strong>Naam:</strong> <?= htmlspecialchars($bedrijf['naam']) ?></li>
            <li class="list-group-item"><strong>Adres:</strong> <?= htmlspecialchars($bedrijf['adres']) ?>, <?= htmlspecialchars($bedrijf['postcode']) ?> <?= htmlspecialchars($bedrijf['plaats']) ?></li>
            <li class="list-group-item"><strong>Land:</strong> <?= htmlspecialchars($bedrijf['land']) ?></li>
            <li class="list-group-item"><a href="../companies/bekijken.php?id=<?= urlencode($d['company_id']) ?>" class="btn btn-sm btn-outline-primary mt-2">Bekijk bedrijf</a></li>
        </ul>
    <?php endif; ?>

    <a href="index.php" class="btn btn-secondary">← Terug naar deals</a>
</div>
</body>
</html>
