<?php
$contactsFile = '../data/contacts.json';
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = uniqid();
    $contacts[$id] = [
        'naam' => $_POST['naam'],
        'email' => $_POST['email'],
        'mobiel' => $_POST['mobiel'],
        'functie' => $_POST['functie'],
        'label' => $_POST['label'],
        'adres' => $_POST['adres'],
        'postcode' => $_POST['postcode'],
        'plaats' => $_POST['plaats'],
        'land' => $_POST['land'],
        'opmerkingen' => $_POST['opmerkingen']
    ];
    file_put_contents($contactsFile, json_encode($contacts, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Nieuwe contactpersoon</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Nieuwe contactpersoon</h2>
    <form method="post">
        <div class="mb-3"><input type="text" name="naam" class="form-control" placeholder="Naam" required></div>
        <div class="mb-3"><input type="email" name="email" class="form-control" placeholder="E-mail" required></div>
        <div class="mb-3"><input type="text" name="mobiel" class="form-control" placeholder="Mobiel nummer"></div>
        <div class="mb-3"><input type="text" name="functie" class="form-control" placeholder="Functietitel"></div>
        <div class="mb-3">
            <select name="label" class="form-control">
                <option value="">Selecteer label</option>
                <option value="Bedrijf">Bedrijf</option>
                <option value="Particulier">Particulier</option>
                <option value="Ambassadeur">Ambassadeur</option>
            </select>
        </div>
        <div class="mb-3"><input type="text" name="adres" class="form-control" placeholder="Adres"></div>
        <div class="mb-3"><input type="text" name="postcode" class="form-control" placeholder="Postcode"></div>
        <div class="mb-3"><input type="text" name="plaats" class="form-control" placeholder="Plaats"></div>
        <div class="mb-3"><input type="text" name="land" class="form-control" placeholder="Land"></div>
        <div class="mb-3"><textarea name="opmerkingen" class="form-control" placeholder="Opmerkingen"></textarea></div>
        <button type="submit" class="btn btn-success">Opslaan</button>
    </form>
</div>
</body>
</html>
