<?php
session_start();
if (!isset($_SESSION['ingelogd'])) {
    header('Location: ../login.php');
    exit;
}

// Data inladen
$contactsFile = '../data/contacts.json';
$companiesFile = '../data/companies.json';

$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];
$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <link rel="icon" type="image/png" href="/crm/favicon.png">
    <meta charset="UTF-8">
    <title>Contactpersonen</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Contactpersonen</h2>
    <a href="nieuw.php" class="btn btn-primary mb-3">Nieuwe contactpersoon</a>

    <?php if (count($contacts) === 0): ?>
        <p>Er zijn nog geen contactpersonen.</p>
    <?php else: ?>
        <table class="table table-striped table-bordered align-middle">
            <thead class="table-dark">
                <tr>
                    <th>Naam</th>
                    <th>Email</th>
                    <th>Mobiel</th>
                    <th>Bedrijf</th>
                    <th>Acties</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($contacts as $id => $c): ?>
                    <tr>
                        <td><?= htmlspecialchars($c['naam']) ?></td>
                        <td><?= htmlspecialchars($c['email']) ?></td>
                        <td><?= htmlspecialchars($c['mobiel']) ?></td>
                        <td>
                            <?php
                            $bedrijfNaam = '—';
                            foreach ($companies as $coId => $co) {
                                if (($co['contact_id'] ?? '') === $id) {
                                    $bedrijfNaam = '<a href="../companies/bekijken.php?id=' . urlencode($coId) . '">' . htmlspecialchars($co['naam']) . '</a>';
                                    break;
                                }
                            }
                            echo $bedrijfNaam;
                            ?>
                        </td>
                        <td class="d-flex gap-1 flex-wrap">
                            <a href="bewerken.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-warning">Bewerken</a>
                            <a href="verwijderen.php?id=<?= urlencode($id) ?>" class="btn btn-sm btn-danger">Verwijderen</a>
                        </td>
                    </tr>
                <?php endforeach ?>
            </tbody>
        </table>
    <?php endif ?>
</div>
</body>
</html>
