<?php
$contactsFile = '../data/contacts.json';
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($contacts[$id])) {
    die('Contactpersoon niet gevonden.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $contacts[$id] = [
        'naam' => $_POST['naam'],
        'email' => $_POST['email'],
        'mobiel' => $_POST['mobiel'],
        'functie' => $_POST['functie'],
        'label' => $_POST['label'],
        'adres' => $_POST['adres'],
        'postcode' => $_POST['postcode'],
        'plaats' => $_POST['plaats'],
        'land' => $_POST['land'],
        'opmerkingen' => $_POST['opmerkingen']
    ];
    file_put_contents($contactsFile, json_encode($contacts, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}

$c = $contacts[$id];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Contactpersoon bewerken</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Contactpersoon bewerken</h2>
    <form method="post">
        <div class="mb-3">
            <label for="naam" class="form-label">Naam *</label>
            <input type="text" name="naam" id="naam" class="form-control" value="<?= htmlspecialchars($c['naam']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">E-mailadres *</label>
            <input type="email" name="email" id="email" class="form-control" value="<?= htmlspecialchars($c['email']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="mobiel" class="form-label">Mobiel telefoonnummer</label>
            <input type="text" name="mobiel" id="mobiel" class="form-control" value="<?= htmlspecialchars($c['mobiel']) ?>">
        </div>

        <div class="mb-3">
            <label for="functie" class="form-label">Functietitel</label>
            <input type="text" name="functie" id="functie" class="form-control" value="<?= htmlspecialchars($c['functie']) ?>">
        </div>

        <div class="mb-3">
            <label for="label" class="form-label">Label</label>
            <select name="label" id="label" class="form-select">
                <option value="">Selecteer label</option>
                <option value="Bedrijf" <?= $c['label'] === 'Bedrijf' ? 'selected' : '' ?>>Bedrijf</option>
                <option value="Particulier" <?= $c['label'] === 'Particulier' ? 'selected' : '' ?>>Particulier</option>
                <option value="Ambassadeur" <?= $c['label'] === 'Ambassadeur' ? 'selected' : '' ?>>Ambassadeur</option>
            </select>
        </div>

        <div class="mb-3">
            <label for="adres" class="form-label">Adres</label>
            <input type="text" name="adres" id="adres" class="form-control" value="<?= htmlspecialchars($c['adres']) ?>">
        </div>

        <div class="mb-3">
            <label for="postcode" class="form-label">Postcode</label>
            <input type="text" name="postcode" id="postcode" class="form-control" value="<?= htmlspecialchars($c['postcode']) ?>">
        </div>

        <div class="mb-3">
            <label for="plaats" class="form-label">Plaats</label>
            <input type="text" name="plaats" id="plaats" class="form-control" value="<?= htmlspecialchars($c['plaats']) ?>">
        </div>

        <div class="mb-3">
            <label for="land" class="form-label">Land</label>
            <input type="text" name="land" id="land" class="form-control" value="<?= htmlspecialchars($c['land']) ?>">
        </div>

        <div class="mb-3">
            <label for="opmerkingen" class="form-label">Opmerkingen / Aantekeningen</label>
            <textarea name="opmerkingen" id="opmerkingen" class="form-control"><?= htmlspecialchars($c['opmerkingen']) ?></textarea>
        </div>

        <button type="submit" class="btn btn-success">Bijwerken</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
