<?php
$companiesFile = '../data/companies.json';
$contactsFile = '../data/contacts.json';

$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($companies[$id])) {
    die('Bedrijf niet gevonden.');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $companies[$id] = [
        'naam' => $_POST['naam'],
        'label' => $_POST['label'],
        'adres' => $_POST['adres'],
        'postcode' => $_POST['postcode'],
        'plaats' => $_POST['plaats'],
        'land' => $_POST['land'],
        'opmerkingen' => $_POST['opmerkingen'],
        'contact_id' => $_POST['contact_id'] ?? ''
    ];
    file_put_contents($companiesFile, json_encode($companies, JSON_PRETTY_PRINT));
    header('Location: index.php');
    exit;
}

$bedrijf = $companies[$id];
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bedrijf bewerken</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Bedrijf bewerken</h2>
    <form method="post">
        <div class="mb-3">
            <label for="naam" class="form-label">Naam</label>
            <input type="text" name="naam" id="naam" class="form-control" value="<?= htmlspecialchars($bedrijf['naam']) ?>" required>
        </div>

        <div class="mb-3">
            <label for="label" class="form-label">Label</label>
            <select name="label" id="label" class="form-select">
                <option value="">Selecteer label</option>
                <option value="Bedrijf" <?= $bedrijf['label'] === 'Bedrijf' ? 'selected' : '' ?>>Bedrijf</option>
                <option value="Particulier" <?= $bedrijf['label'] === 'Particulier' ? 'selected' : '' ?>>Particulier</option>
                <option value="Ambassadeur" <?= $bedrijf['label'] === 'Ambassadeur' ? 'selected' : '' ?>>Ambassadeur</option>
            </select>
        </div>

        <div class="mb-3">
            <label for="adres" class="form-label">Adres</label>
            <input type="text" name="adres" id="adres" class="form-control" value="<?= htmlspecialchars($bedrijf['adres']) ?>">
        </div>

        <div class="mb-3">
            <label for="postcode" class="form-label">Postcode</label>
            <input type="text" name="postcode" id="postcode" class="form-control" value="<?= htmlspecialchars($bedrijf['postcode']) ?>">
        </div>

        <div class="mb-3">
            <label for="plaats" class="form-label">Plaats</label>
            <input type="text" name="plaats" id="plaats" class="form-control" value="<?= htmlspecialchars($bedrijf['plaats']) ?>">
        </div>

        <div class="mb-3">
            <label for="land" class="form-label">Land</label>
            <input type="text" name="land" id="land" class="form-control" value="<?= htmlspecialchars($bedrijf['land']) ?>">
        </div>

        <div class="mb-3">
            <label for="opmerkingen" class="form-label">Opmerkingen</label>
            <textarea name="opmerkingen" id="opmerkingen" class="form-control"><?= htmlspecialchars($bedrijf['opmerkingen']) ?></textarea>
        </div>

        <div class="mb-3">
            <label for="contact_id" class="form-label">Koppel contactpersoon</label>
            <select name="contact_id" id="contact_id" class="form-select">
                <option value="">— Geen —</option>
                <?php foreach ($contacts as $cid => $contact): ?>
                    <option value="<?= $cid ?>" <?= ($bedrijf['contact_id'] ?? '') === $cid ? 'selected' : '' ?>>
                        <?= htmlspecialchars($contact['naam']) ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <button type="submit" class="btn btn-success">Bijwerken</button>
        <a href="index.php" class="btn btn-secondary">Annuleren</a>
    </form>
</div>
</body>
</html>
