<?php
$companiesFile = '../data/companies.json';
$contactsFile = '../data/contacts.json';

$companies = file_exists($companiesFile) ? json_decode(file_get_contents($companiesFile), true) : [];
$contacts = file_exists($contactsFile) ? json_decode(file_get_contents($contactsFile), true) : [];

$id = $_GET['id'] ?? '';
if (!isset($companies[$id])) {
    die('Bedrijf niet gevonden.');
}

// Verwijderen omzetregel
if (isset($_GET['verwijder_omzet'])) {
    $index = (int)$_GET['verwijder_omzet'];
    if (isset($companies[$id]['omzetregels'][$index])) {
        array_splice($companies[$id]['omzetregels'], $index, 1);
        file_put_contents($companiesFile, json_encode($companies, JSON_PRETTY_PRINT));
        header("Location: bekijken.php?id=$id");
        exit;
    }
}

$c = $companies[$id];
$contact = !empty($c['contact_id']) && isset($contacts[$c['contact_id']]) ? $contacts[$c['contact_id']] : null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Statussen bijwerken via formulier
    if (isset($_POST['update_statusen'])) {
        foreach ($_POST['status'] as $index => $nieuweStatus) {
            if (isset($companies[$id]['omzetregels'][$index])) {
                $companies[$id]['omzetregels'][$index]['status'] = $nieuweStatus;
            }
        }
    }
    // Nieuwe omzetregel toevoegen
    elseif (isset($_POST['toevoegen_omzet']) && !empty($_POST['omzet_bedrag']) && is_numeric($_POST['omzet_bedrag'])) {
        $companies[$id]['omzetregels'][] = [
            'datum' => $_POST['omzet_datum'] ?? date('Y-m-d'),
            'bedrag' => floatval($_POST['omzet_bedrag']),
            'omschrijving' => $_POST['omzet_omschrijving'] ?? '',
            'status' => $_POST['omzet_status'] ?? 'Wachten op betaling'
        ];
    }
    // Notities en logboek
    elseif (isset($_POST['log_actie']) || isset($_POST['notities'])) {
        $companies[$id]['notities'] = $_POST['notities'] ?? '';

        if (!empty($_POST['log_actie'])) {
            $companies[$id]['logboek'][] = [
                'moment' => date('Y-m-d H:i'),
                'actie' => $_POST['log_actie']
            ];
        }
    }

    file_put_contents($companiesFile, json_encode($companies, JSON_PRETTY_PRINT));
    header("Location: bekijken.php?id=$id");
    exit;
}

$c = $companies[$id];
$omzetregels = $c['omzetregels'] ?? [];
$totaalOmzet = 0;
foreach ($omzetregels as $regel) {
    if (($regel['status'] ?? '') === 'Betaald') {
        $totaalOmzet += $regel['bedrag'];
    }
}
?>

<!DOCTYPE html>
<html lang="nl">
<head>
    <meta charset="UTF-8">
    <title>Bedrijf bekijken</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include '../includes/menu.php'; ?>
<div class="container py-5">
    <h2 class="mb-4">Bedrijf: <?= htmlspecialchars($c['naam']) ?></h2>

    <div class="mb-4">
        <p><strong>Adres:</strong> <?= htmlspecialchars($c['adres']) ?>, <?= htmlspecialchars($c['postcode']) ?> <?= htmlspecialchars($c['plaats']) ?></p>
        <p><strong>Land:</strong> <?= htmlspecialchars($c['land']) ?></p>
        <p><strong>Type:</strong> <?= htmlspecialchars($c['label']) ?></p>
    </div>

    <?php if ($contact): ?>
        <h4>Contactpersoon</h4>
        <ul class="list-group mb-4">
            <li class="list-group-item"><strong>Naam:</strong> <?= htmlspecialchars($contact['naam']) ?></li>
            <li class="list-group-item"><strong>E-mail:</strong> <a href="mailto:<?= htmlspecialchars($contact['email']) ?>"><?= htmlspecialchars($contact['email']) ?></a></li>
            <li class="list-group-item"><strong>Mobiel:</strong> <?= htmlspecialchars($contact['mobiel']) ?></li>
            <li class="list-group-item"><strong>Functie:</strong> <?= htmlspecialchars($contact['functie']) ?></li>
        </ul>
    <?php endif; ?>

    <!-- ✅ Omzet toevoegen -->
    <div class="mb-5">
        <h4>Nieuwe omzetregel</h4>
        <form method="post" class="row g-3">
            <div class="col-md-2">
                <input type="date" name="omzet_datum" class="form-control" value="<?= date('Y-m-d') ?>">
            </div>
            <div class="col-md-2">
                <input type="number" step="0.01" name="omzet_bedrag" class="form-control" placeholder="Bedrag in €">
            </div>
            <div class="col-md-3">
                <input type="text" name="omzet_omschrijving" class="form-control" placeholder="Omschrijving">
            </div>
            <div class="col-md-3">
                <select name="omzet_status" class="form-select">
                    <option value="Wachten op betaling">⏳ Wachten op betaling</option>
                    <option value="Betaald">✅ Betaald</option>
                    <option value="Niet betaald">❌ Niet betaald</option>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-success" name="toevoegen_omzet">Toevoegen</button>
            </div>
        </form>
    </div>

    <?php if (count($omzetregels) > 0): ?>
        <h4>Omzetregels</h4>
        <form method="post">
            <input type="hidden" name="update_statusen" value="1">
            <table class="table table-sm table-bordered mb-4">
                <thead class="table-light">
                    <tr>
                        <th>Datum</th>
                        <th>Bedrag</th>
                        <th>Omschrijving</th>
                        <th>Status</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($omzetregels as $i => $regel): ?>
                        <tr>
                            <td><?= isset($regel['datum']) ? date('d-m-Y', strtotime($regel['datum'])) : '—' ?></td>
                            <td>€ <?= number_format($regel['bedrag'], 2, ',', '.') ?></td>
                            <td><?= htmlspecialchars($regel['omschrijving']) ?></td>
                            <td>
                                <select name="status[<?= $i ?>]" class="form-select form-select-sm">
                                    <option value="Wachten op betaling" <?= ($regel['status'] ?? '') === 'Wachten op betaling' ? 'selected' : '' ?>>⏳ Wachten op betaling</option>
                                    <option value="Betaald" <?= ($regel['status'] ?? '') === 'Betaald' ? 'selected' : '' ?>>✅ Betaald</option>
                                    <option value="Niet betaald" <?= ($regel['status'] ?? '') === 'Niet betaald' ? 'selected' : '' ?>>❌ Niet betaald</option>
                                </select>
                            </td>
                            <td><a href="bekijken.php?id=<?= urlencode($id) ?>&verwijder_omzet=<?= $i ?>" class="btn btn-sm btn-danger">Verwijder</a></td>
                        </tr>
                    <?php endforeach ?>
                </tbody>
            </table>
            <button type="submit" class="btn btn-primary">Statussen opslaan</button>
        </form>
        <div class="alert alert-info">
            💶 Totale betaalde omzet: <strong>€ <?= number_format($totaalOmzet, 2, ',', '.') ?></strong>
        </div>
    <?php endif; ?>

    <form method="post" class="mb-5">
        <div class="mb-3">
            <label for="notities" class="form-label">Notities</label>
            <textarea name="notities" id="notities" class="form-control" rows="3"><?= htmlspecialchars($c['notities'] ?? '') ?></textarea>
        </div>

        <div class="mb-3">
            <label for="log_actie" class="form-label">Nieuw logboek-item</label>
            <input type="text" name="log_actie" id="log_actie" class="form-control" placeholder="Bijv: Gebeld, offerte verstuurd...">
        </div>

        <button type="submit" class="btn btn-success">Opslaan</button>
        <a href="index.php" class="btn btn-secondary">Terug</a>
    </form>

    <?php if (!empty($c['logboek'])): ?>
        <h4>Logboek</h4>
        <ul class="list-group">
            <?php foreach (array_reverse($c['logboek']) as $log): ?>
                <li class="list-group-item">
                    <?php
                    $moment = DateTime::createFromFormat('Y-m-d H:i', $log['moment']);
                    echo '<strong>' . ($moment ? $moment->format('d-m-Y H:i') : $log['moment']) . ':</strong> ';
                    ?>
                    <?= htmlspecialchars($log['actie']) ?>
                </li>
            <?php endforeach ?>
        </ul>
    <?php endif; ?>
</div>
</body>
</html>