<?php
session_start();
require_once 'config.php';

if (!$_SESSION['logged_in']) die("Niet ingelogd.");

// Verzenden
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $from = $_POST['from'];
$to = $_POST['reply_mode'] ?? false ? $_POST['to'] : $_POST['to'];
    $subject = $_POST['subject'];
    $message = $_POST['message'];

    if (!isset($mailboxes[$from])) die("Ongeldige afzender.");

    $box = $mailboxes[$from];
    $boundary = uniqid('np');

    // Bijlage verwerken
    $attachmentPart = '';
    if (isset($_FILES['attachment']) && $_FILES['attachment']['error'] === UPLOAD_ERR_OK) {
        $fileContent = file_get_contents($_FILES['attachment']['tmp_name']);
        $fileName = $_FILES['attachment']['name'];
        $fileEncoded = chunk_split(base64_encode($fileContent));

        $attachmentPart = "--$boundary\r\n";
        $attachmentPart .= "Content-Type: application/octet-stream; name=\"$fileName\"\r\n";
        $attachmentPart .= "Content-Transfer-Encoding: base64\r\n";
        $attachmentPart .= "Content-Disposition: attachment; filename=\"$fileName\"\r\n\r\n";
        $attachmentPart .= "$fileEncoded\r\n";
    }

    // Headers + body
    $headers = "From: $from\r\n";
    $headers .= "MIME-Version: 1.0\r\n";
    $headers .= "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n\r\n";

    $body = "--$boundary\r\n";
    $body .= "Content-Type: text/plain; charset=\"UTF-8\"\r\n";
    $body .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
    $body .= "$message\r\n\r\n";
    $body .= $attachmentPart;
    $body .= "--$boundary--";

    // SMTP verzenden via fsockopen
    $smtp = fsockopen($box['smtp_host'], $box['smtp_port'], $errno, $errstr, 10);
    if (!$smtp) die("SMTP-fout: $errstr");

    function sendLine($smtp, $cmd) {
        fputs($smtp, $cmd . "\r\n");
        return fgets($smtp, 515);
    }

    $resp = fgets($smtp, 515);
    sendLine($smtp, "EHLO localhost");
    fgets($smtp, 515);
    sendLine($smtp, "AUTH LOGIN");
    sendLine($smtp, base64_encode($box['username']));
    sendLine($smtp, base64_encode($box['password']));
    sendLine($smtp, "MAIL FROM: <$from>");
    sendLine($smtp, "RCPT TO: <$to>");
    sendLine($smtp, "DATA");
    fputs($smtp, $headers . $body . "\r\n.\r\n");
    sendLine($smtp, "QUIT");
    fclose($smtp);

    $success = true;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>E-mail verzenden</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<a href="dashboard.php">← Terug naar inbox</a>
<h2>Nieuwe e-mail verzenden</h2>
<?php if (!empty($success)) echo "<p style='color:green;'>Verzonden!</p>"; ?>
<form method="post" enctype="multipart/form-data">
    <label>Van:</label>
    <select name="from" required>
        <?php foreach ($mailboxes as $email => $cfg): ?>
            <option value="<?= $email ?>"><?= $email ?></option>
        <?php endforeach; ?>
    </select><br>

    <label>Aan:</label>
    <input type="email" name="to" required><br>

    <label>Onderwerp:</label>
    <input type="text" name="subject" required><br>

    <label>Bericht:</label>
    <textarea name="message" rows="10" required></textarea><br>

    <label>Bijlage (optioneel):</label>
    <input type="file" name="attachment"><br>

    <button type="submit">Verstuur e-mail</button>
</form>
</body>
</html>
